﻿using System;
using System.Linq;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows.Media.Animation;
using Microsoft.Phone.Controls;

namespace ListBoxSelectionAnimation
{
public partial class MainPage : PhoneApplicationPage
{
    private readonly Point emptyPoint = new Point();
    private DoubleAnimation animationX;
    private DoubleAnimation animationY;
    private Storyboard storyboard;

    public MainPage()
    {
        InitializeComponent();

        this.listbox.ItemsSource = Enumerable.Range(1, 32);

        this.Loaded += this.OnLoaded;
    }

    private void OnLoaded(object sender, RoutedEventArgs routedEventArgs)
    {
        this.Loaded -= this.OnLoaded;

        this.listbox.SelectionChanged += this.OnSelectionChanged;

        this.overlayHost.Height = this.listbox.ActualHeight;
        this.overlayHost.Width = this.listbox.ActualWidth;
        this.overlayHost.Margin = this.listbox.Margin;

        this.UpdateHighlightedItem();
    }

    private void OnSelectionChanged(object sender, SelectionChangedEventArgs e)
    {
        this.UpdateHighlightedItem();
    }

    private void UpdateHighlightedItem()
    {
        var element = this.listbox.ItemContainerGenerator.ContainerFromIndex(this.listbox.SelectedIndex) as FrameworkElement;
        if (element != null)
        {
            // compute the location of the selected element
            Point destination = element.TransformToVisual(this.listbox).Transform(this.emptyPoint);
            Point origin = this.iconOverlay.TransformToVisual(this.listbox).Transform(this.emptyPoint);

            var translateTransform = this.iconOverlay.RenderTransform as TranslateTransform;
            if (translateTransform == null)
            {
                translateTransform = new TranslateTransform();
                this.iconOverlay.RenderTransform = translateTransform;

                TimeSpan duration = TimeSpan.FromMilliseconds(150);
                IEasingFunction ease = new QuarticEase { EasingMode = EasingMode.EaseOut };

                this.animationX = new DoubleAnimation { Duration = duration, EasingFunction = ease };
                this.animationY = new DoubleAnimation { Duration = duration, EasingFunction = ease };

                this.storyboard = new Storyboard();
                this.storyboard.Children.Add(this.animationX);
                this.storyboard.Children.Add(this.animationY);
            }
            else
            {
                this.storyboard.Stop();
            }

            Storyboard.SetTarget(this.animationX, translateTransform);
            Storyboard.SetTarget(this.animationY, translateTransform);
            Storyboard.SetTargetProperty(this.animationX, new PropertyPath(TranslateTransform.XProperty));
            Storyboard.SetTargetProperty(this.animationY, new PropertyPath(TranslateTransform.YProperty));

            this.animationX.From = origin.X;
            this.animationY.From = origin.Y;
            this.animationX.To = destination.X;
            this.animationY.To = destination.Y;

            this.storyboard.Begin();
        }
    }
}
}